<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'user';
    public $timestamps = true;

    public function address()
    {
        return $this->hasMany('Address');
    }

    public function reviews()
    {
        return $this->hasMany('Review');
    }

    public function cart()
    {
        return $this->hasOne('Cart');
    }

    public function favouriteProducts()
    {
        return $this->belongsToMany('Product', 'favourites');
    }

    public function notifications()
    {
        return $this->hasMany('Notification');
    }

}